/*------------------------------------------------------------------------------*
 *	File Name: 	wks2mat.h									 					*
 *	Purpose:	VC functions needed by worksheet-to-matrix converting			*
 *				This header is used in VC ocMath DLL as well as in OC files		*
 *	This header includes prototypes of											*
 *		Replace Duplicates	#6751												*
 *		Examine Data		#5527												*
 *		Sparse XYZ data		#6409												*
 *		Regular XYZ data	#4253 												*
 *		Random XYZ: Thin plate spline	#6278			ocTPS.cpp				*
 *		Random XYZ: Nag (Shepard)		#6421, #4241	Mathlib\ocScatIntp.cpp	*
 *		Random XYZ: Nag (Renka Cline)	#6421, #4241	Mathlib\ocScatIntp.cpp	*
 *		Random XYZ: Correlation			#4096, #4088	ocKrig.cpp				*
 *																				*
 *  Creation:	07/20/04, Soapy													* 
 *  	Copyright Originlab Corp.		2004, 2005								*
 *	Modification log	                                                        *
 *	Soapy 07/06/04  QA7.06278  MODIFY_TPS										*
 *	Leo 03/16/05	LLVC_MAT_TO_REGULAR_XYZ										*
 *	Soapy 3/23/05 MOVE_RENKACLINE_MODSHEPARD_METHOD_FOR_2D_INTERPOLATION		*
 *	Leo	03/23/05	ADD_HIGH_LEVEL_EXAMPLE_2									*
 *	Soapy  03/30/05  QA70-6421	DEAL_WITH_XY_RANGE_DIFFERENCE					*
 *	Leo	03/23/05	ADD_TPS_EXAMPLE_2											*
 *	Soapy 03/30/05	QA70-6421 DEAL_WITH_X_Y_RANGE_DIFFERENCE					*
 *	Soapy 04/06/05  COMPUTE_HISTOGRAM_ON_INTERVAL								*
 *	Leo 04/11/05 #QA70-7604 LLVC_MAT_REPLACE_BLANKS								*
 *	Leo 06/01/05 v8.0244B OCMATH_SELECT_XY_DATA									*
 *	Mouqx/Leo 09/26/05	CHANGE_PRECISION_FROM_INT_TO_DOUBLE						*
 *  Roy 03/16/2006	OCMATH_XYZ_GRIDDING											*
 *  Roy 03/17/2006	OCMATH_D_POLYGON_REORDER									*
 *	ML 3/22/2006 PROTOTYPE_WITH_CONSTS											*
 *	ML 3/22/2006 GRIDDING_BETTER_DEFAULT_VALUES									*
 *  Justin 2007-03-26 MODIFY_CATEGORY											*
 *	Cloud 05/16/2008 MODIFY_CATEGORY											*
 *	Jack  9-19-2008 QA80-12191  SEPERATE_PRECISION_TOLERANCE_FOR_REMOVE_DUPPLICATES_AND_FIND_ARRAY_STEPS *
 *	Jack  9-23-2008 QA80-12191  SEPERATE_PRECISION_TOLERANCE_FOR_REMOVE_DUPPLICATES_AND_FIND_ARRAY_STEPS *
 *  Will  6/19/2009	QA80-13783 PROTOTYPE_WITH_TWO_PRECISION_FOR_XYZ_REMOVE_DUPLICATE
 *  Will  6/19/2009 QA80-13783 REMOVE_DUPLICATES_FOR_ARRAY
 *  Will  6/19/2009 QA80-13783 CHANGE_PROTOTYPE_AND_ALGORITHM_FOR_EXAMINATION
 *	Sim 09-25-2009 QA80-13783 PROTOTYPE_WITH_TWO_PRECISION_FOR_XYZ_REMOVE_DUPLICATE
 *	Sim 09-25-2009 QA80-13783 CHANGE_PROTOTYPE_AND_ALGORITHM_FOR_EXAMINATION
 *	Fisher 07-08-2009 QA80-13783 IMPROVE_SPARSE_XYZ_TO_MATRIX_CONVERTION		*
 *	Fisher Qa80-11497 09/16/09  KRIGGING_CORRELATION_TOO_SLOW_FOR_LARGE_DATA	*
 *------------------------------------------------------------------------------*/

#ifndef _WKS_TO_MAT_H
#define _WKS_TO_MAT_H
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////
// function declarations
//////////////////////////////////////////////////////////
#ifdef _MSC_VER	   //VC
	#ifdef OCMATH_EXPORTS
		#define OCMATH_API __declspec(dllexport)
	/// TD 06-19-2008 QA80-10844 TRICTR_IN_VIEWER
	#elif  defined(MIN_OK_VERSION)
		#define OCMATH_API
	/// end QA80-10844 TRICTR_IN_VIEWER
	#else
		#define OCMATH_API __declspec(dllimport)
	#endif
	extern "C" {
#else //_MSC_VER
	#define OCMATH_API
	#pragma dll(ocMath)	// Assoicate all functions below to ocMath.dll which must be in the Origin EXE folder
#endif	//!_MSC_VER 

#define		NANUM		(-1.23456789E-300)

//Method in removing the duplicates, where 0 means replace with mean, 1=median, 2=min, 3=max, 4=sum
enum {
	Remove_With_Mean = 0,
	Remove_With_Median,
	Remove_With_Min,
	Remove_With_Max,
	Remove_With_Sum,
///Jack	09/23/2008 QA80-12191 SEPERATE_PRECISION_TOLERANCE_FOR_REMOVE_DUPPLICATES_AND_FIND_ARRAY_STEPS
// do not remove       for large data set this mode can save time as no need sorting
	Remove_None
/// End SEPERATE_PRECISION_TOLERANCE_FOR_REMOVE_DUPPLICATES_AND_FIND_ARRAY_STEPS
};

//Return value of ocmath_xyz_examine_data()
enum {
	Examine_XYZ_Fail = -1,
	Examine_XYZ_Regular = 0,
	Examine_XYZ_Sparse,
	Examine_XYZ_Random
};
///Soapy 07/06/04  QA7.06278  MODIFY_TPS
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_strTPS
*/
typedef struct 
{
	bool bsucess;
	int nNode;
	double *x;
	double *y;
	///Soapy 03/30/04	QA70-6421 DEAL_WITH_X_Y_RANGE_DIFFERENCE
	double dXScale;
	double dYScale;
	///END DEAL_WITH_X_Y_RANGE_DIFFERENCE

	double *coeff;

	// Boundary points
	int nB;
	double *pbndx;
	double *pbndy;

} ocmath_strTPS;

///END Soapy 07/06/04  QA7.06278  MODIFY_TPS

///Eric/Leo  01/10/06  CHANGE_ERROR_CODE_FOR_RETURN
/*
enum {ERR_TPS_NO_ERROR = 0,
	ERR_TPS_INVALID_POINT,
	ERR_TPS_NULL_POINTER,
	ERR_TPS_INVALID_SMOOTH,
	ERR_TPS_FIT}; 

enum {  // Error return by ocmath_2d_kriging_scat() and ocmath_2d_kriging_grid()
	Err_Krig_No_Error = 0,
	Err_Krig_Invalid_Fitting_Parameters, 
	Err_Krig_Invalid_Array_Pointer,
	Err_Krig_Not_Enough_Points,
	Err_Krig_Solve_Linear_System_Fail
}; 
*/
/*///Leo 2006-1-11 
//---- CPY 1/10/06 XYZ2MAT_COMPILE_PROBLEM
// I have to bring this back here, as otherwise cannot compile
enum {ERR_TPS_NO_ERROR = 0,
	ERR_TPS_INVALID_POINT,
	ERR_TPS_NULL_POINTER,
	ERR_TPS_INVALID_SMOOTH,
	ERR_TPS_FIT};
//----
*/
///Soapy 3/23/05 MOVE_RENKACLINE_MODSHEPARD_METHOD_FOR_2D_INTERPOLATION
// The following type definition are for 2d interpolation using Renka&Cline method and Modified Shepard's method
typedef enum {  // Error return by ocmath_2d_scat_interpolant()
	Err_Intp_No_Error = 0,
	Err_Intp_Mem_Fail, 
	Err_Intp_Invalid_Point,
	Err_Intp_Duplicate_Point
}Err_Intp; 

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_ModShepard_Struct
*/
typedef struct{
	int exit_status; // specifies the status of calling ocmath_2d_scat_interpolant()
	double *x;  // the position and the value of the scattering points
	double *y;
	double *f;
	int np;     // the number of scatter points

	// For Modified Shepard's Method
	int nr;    
	int nq;
	int nw;

	double xmin;
	double ymin;
	double dx;
	double dy;
	double rmax;

	///Soapy  03/30/05  QA70-6421	DEAL_WITH_XY_RANGE_DIFFERENCE
	double dXScale;
	double dYScale;
	///END	DEAL_WITH_XY_RANGE_DIFFERENCE

	int* pLCell;
	int* pLNext;
	double* pRsq;
	double* a;

} ocmath_ModShepard_Struct;

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_ModShepard_Opt
*/
typedef struct{
  int nw;
  int nq;
} ocmath_ModShepard_Opt;

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_RenkaCline_Struct
*/
typedef struct{
	int exit_status; // specifies the status of calling ocmath_2d_scat_interpolant()
	double *x;  // the position and the value of the scattering points
	double *y;
	double *f;
	int np;     // the number of scatter points

	int *iadj;
	int *iend;
	double *zxzy; 

	///Soapy  03/30/05  QA70-6421	DEAL_WITH_XY_RANGE_DIFFERENCE
	double dXScale;
	double dYScale;
	///END	DEAL_WITH_XY_RANGE_DIFFERENCE
} ocmath_RenkaCline_Struct;
///END MOVE_RENKACLINE_MODSHEPARD_METHOD_FOR_2D_INTERPOLATION

enum{
	MRB_MEAN				= 0x0001,
	MRB_MIN					= 0x0002,
	MRB_MAX					= 0x0004,
	MRB_NEAREST_NEIGHBOR	= 0x0010,
	MRB_CUSTOM_VALUE		= 0x0020,
	MRB_IGNORE_LEFT_BORDER	= 0x0100,
	MRB_IGNORE_TOP_BORDER	= 0x0200,
	MRB_IGNORE_RIGHT_BORDER	= 0x0400,
	MRB_IGNORE_BOTTOM_BORDER= 0x0800
};

///last update by Mouqx/Leo 09/26/05
// Category last updated by Echo on 01/21/2009
/**$ >Analysis>Vector and Matrix
	Remarks:
		This function check if the values in the array are spaced by a constant. If yes,
		return the interval. This checking allow points missed on the grid or multi-points
		in the same grid.
	Parameters:
		vIn=[input] the array contains the points;
		nSize=[input] the number of points in the array;
		dInterval=[output] the interval of the grid when the points are spaced on the grid;
		dPrecision=[input] the precision to use when determining if the points are on the grid; 
					
	Return:
		OE_NOERROR when points are spaced equally or else OE_NOT_SPACED_EQUALLY. 
*/
///Eric/Leo 01/9/06  CHANGE_ERROR_CODE_FOR_RETURN
///Mouqx/Leo 09/26/05 CHANGE_PRECISION_FROM_INT_TO_DOUBLE
//OCMATH_API bool ocmath_find_array_step(double* vIn, UINT nSize, double* dInterval, int nPrecision = 8);
OCMATH_API int ocmath_find_array_step(double* vIn, UINT nSize, double* dInterval, double dPrecision = 1.0e-8);

//last update by Mouqx/Leo. 09/26/05
// Category last updated by Echo on 01/21/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_xyz_remove_duplicates_(global_function)
*/
///Eric/Leo 01/9/06  CHANGE_ERROR_CODE_FOR_RETURN
///Kevin 11/29/05 CHANGE_OCMATH_FUNCTION_TO_LOWER_CASE
///Mouqx/Leo 09/26/05 CHANGE_PRECISION_FROM_INT_TO_DOUBLE
//OCMATH_API int ocmath_XYZ_remove_duplicates(UINT n, double* x, double* y, double* z, int nMethod = Remove_With_Mean, int nPrecision = 8);
//OCMATH_API int ocmath_XYZ_remove_duplicates(UINT n, double* x, double* y, double* z, int nMethod = Remove_With_Mean, double dPrecision = 1.0e-8);
///Will  6/19/2009	QA80-13783 PROTOTYPE_WITH_TWO_PRECISION_FOR_XYZ_REMOVE_DUPLICATE
#ifndef  __NEW_XYZ_REMOVE_DUPLICATES_METHOD__
OCMATH_API int ocmath_xyz_remove_duplicates(UINT n, double* x, double* y, double* z, int nMethod = Remove_With_Mean, double dPrecision = 1.0e-8);
#else			 //__NEW_XYZ_REMOVE_DUPLICATES_METHOD__
OCMATH_API int ocmath_xyz_remove_duplicates(UINT n, double* x, double* y, double* z, int nMethod = Remove_With_Mean, double dXPrecision = 1.0e-8,double dYPrecision = 1.0e-8);
#endif		     //__NEW_XYZ_REMOVE_DUPLICATES_METHOD__
///End PROTOTYPE_WITH_TWO_PRECISION_FOR_XYZ_REMOVE_DUPLICATE

enum
{
	GRIDDING_METHOD_RANDOM_RENKA_CLINE,	// Renka&Cline method
	GRIDDING_METHOD_RANDOM_SHEPARD,		// a modification of Shepard's method
	GRIDDING_METHOD_RANDOM_TPS,			// thin plate spline method
	GRIDDING_METHOD_RANDOM_KRIGING,		// Kriging algorithm
	GRIDDING_METHOD_WEIGHTED_AVERAGE	// Weighted average
};

///Roy 03/16/2006	OCMATH_XYZ_GRIDDING
// Comments last updated by Army on 07/31/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_xyz_gridding_(global_function)
*/

/// ML 3/22/2006 GRIDDING_BETTER_DEFAULT_VALUES
//OCMATH_API int ocmath_xyz_gridding(	UINT nSize, const double* vX, const double* vY, const double* vZ, 
//									UINT nGridSize, const double* vxGrid, const double* vyGrid, double* vzGrid, 
//									int iMethod = GRIDDING_METHOD_RANDOM_TPS, 
//									int nq = 8, int nw = 12, double kriging_radius = 2, double average_radius = 2, int min_pts = 3, 
//									double tps_smooth = 0.1, double kriging_smooth = 1.8);
OCMATH_API int ocmath_xyz_gridding(	UINT nSize, const double* vX, const double* vY, const double* vZ, 
									UINT nGridSize, const double* vxGrid, const double* vyGrid, double* vzGrid, 
									int iMethod = GRIDDING_METHOD_RANDOM_TPS, 
									int nq = 12, int nw = 8, double kriging_radius = 2, double average_radius = 2, int min_pts = 3, 
									double tps_smooth = 0.1, double kriging_smooth = 1.8);
/// end GRIDDING_BETTER_DEFAULT_VALUES

///Leo	03/23/05	ADD_HIGH_LEVEL_EXAMPLE_2
///last updated by Mouqx/Leo, 09/26/2005
// Category last updated by Echo on 01/21/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_xyz_examine_data_(global_function)
*/
///Mouqx/Leo 09/26/05 CHANGE_PRECISION_FROM_INT_TO_DOUBLE
//OCMATH_API int ocmath_xyz_examine_data(UINT nSize, double* x, double* y, double* z, int nPrecision = 8, UINT* pVar = NULL,
/// Will 6/19/2009 QA80-13783 CHANGE_PROTOTYPE_AND_ALGORITHM_FOR_EXAMINATION
#ifndef   __NEW_XYZ_EXAMINE_METHOD__
OCMATH_API int ocmath_xyz_examine_data(UINT nSize, double* x, double* y, double* z, double dPrecision = 1.0e-8, UINT* pVar = NULL,
		double* pXmin = NULL, double* pXStep = NULL, double* pXmax = NULL, double* pYmin = NULL, 
		double* pYStep = NULL, double* pYmax = NULL, bool bRemoveDuplicate = false, int nMethod = Remove_With_Mean);
#else // __NEW_XYZ_EXAMINE_METHOD__
OCMATH_API int ocmath_xyz_examine_data(UINT nSize, double* x, double* y, double* z, double dXPrecision = 1.0e-8, double dYPrecision = 1.0e-8, UINT* pVar = NULL,
		double* pXmin = NULL, double* pXStep = NULL, double* pXmax = NULL, double* pYmin = NULL, 
		double* pYStep = NULL, double* pYmax = NULL, bool bRemoveDuplicate = false, int nMethod = Remove_With_Mean);
#endif // __NEW_XYZ_EXAMINE_METHOD__
/// End CHANGE_PROTOTYPE_AND_ALGORITHM_FOR_EXAMINATION

// Sim, after #13783 done, this function wasn't used.
/**$
*/
///Jack  9-19-2008 QA80-12191  SEPERATE_PRECISION_TOLERANCE_FOR_REMOVE_DUPPLICATES_AND_FIND_ARRAY_STEPS
OCMATH_API int ocmath_xyz_examine_data_ex(UINT nSize, double* x, double* y, double* z, double dPrecision = 1.0e-8, UINT* pVar = NULL,
		double* pXmin = NULL, double* pXStep = NULL, double* pXmax = NULL, double* pYmin = NULL, 
		double* pYStep = NULL, double* pYmax = NULL, bool bRemoveDuplicate = false, int nMethod = Remove_With_Mean, double dXStepPrecTol=1, double dYStepPrecTol=1);
///End SEPERATE_PRECISION_TOLERANCE_FOR_REMOVE_DUPPLICATES_AND_FIND_ARRAY_STEPS

// Comments last updated by Jospeh on 08/10/2007
// Category last updated by Echo on 01/21/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_convert_regular_xyz_to_matrix_(global_function)
*/
///Eric/Leo 01/9/06  CHANGE_ERROR_CODE_FOR_RETURN
OCMATH_API int ocmath_convert_regular_xyz_to_matrix(UINT nSize, double* x, double* y, double* z,
	double* matResult, double dXmin, double dXStep, UINT nXlen, 
	double dYmin, double dYStep, UINT nYlen);


//last updated by Mouqx/Leo 09/26/05
// Comments last updated by Jospeh on 08/10/2007
// Category last updated by Echo on 01/21/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_convert_sparse_xyz_to_matrix_(global_function)
*/
///Eric/Leo 01/9/06  CHANGE_ERROR_CODE_FOR_RETURN
OCMATH_API int ocmath_convert_sparse_xyz_to_matrix(UINT nSize, double* x, double* y, double* z,
	double* matResult, double dXmin, double dXStep, UINT nXlen, 
	/// Fisher 07-08-2009 QA80-13783 IMPROVE_SPARSE_XYZ_TO_MATRIX_CONVERTION
	//double dYmin, double dYStep, UINT nYlen, double dPrecision = 1.0e-8);
	double dYmin, double dYStep, UINT nYlen, double dPrecisionX = 1.0e-8, double dPrecisionY = 1.0e-8);
	/// End IMPROVE_SPARSE_XYZ_TO_MATRIX_CONVERTION

///Leo 03/11/05 LLVC_MAT_TO_REGULAR_XYZ
// Category last updated by Echo on 01/21/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_mat_to_regular_xyz_(global_function)
*/
///Eric/Leo 01/9/06  CHANGE_ERROR_CODE_FOR_RETURN
OCMATH_API int ocmath_mat_to_regular_xyz(const double* pMat, int nRows, int nCols, double dXmin, double dXmax, double dYmin, double dYmax, double* px, double* py, double* pz = NULL, BOOL bColOrder=true);
///END LLVC_MAT_TO_REGULAR_XYZ
///END ADD_HIGH_LEVEL_EXAMPLE_2

///Leo 04/11/05 #QA70-7604 LLVC_MAT_REPLACE_BLANKS
// Category last updated by Echo on 01/21/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_mat_replace_blanks_(global_function)
*/
OCMATH_API int ocmath_mat_replace_blanks(double* pMat, int nRows, int nCols, int iLeft = -1, int iTop = -1, int iRight = -1, int iBottom = -1, int iOptions = MRB_CUSTOM_VALUE, double dValue = 0);
///END LLVC_MAT_REPLACE_BLANKS

///Leo 06/01/05 v8.0244B OCMATH_SELECT_XY_DATA
// Comments last updated by Jospeh on 08/10/2007
// Category last updated by Echo on 01/21/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_find_xy_in_rect_(global_function)
*/
///Leo 2005-12-29 SIMPLIFY_CALCULATIONS
//OCMATH_API int ocmath_select_xy_data(uint nPts, const double* pX, const double* pY,
//	uint* pIndices, double dXMin, double dYMin, double dXMax, double dYMax);
OCMATH_API int ocmath_find_xy_in_rect(uint nPts, const double* pX, const double* pY,
	uint* pIndices, double dxMin, double dyMin, double dxMax, double dyMax);
///End OCMATH_SELECT_XY_DATA

///Soapy 04/06/05	COMPUTE_HISTOGRAM_ON_INTERVAL
// Category last updated by Cloud on 05/16/2008
/**$ >Analysis>Vector and Matrix
	Remarks:
		Calculate the differences between each two points. 
	Parameters:
		nPts=[input] the number of points in array pCoordinates.
		pCoordinates=[input] the coordinates of points.
		pIntervals=[output] the differences between each two points in pCoordinates. 
			The size of pIntervals should be no less than (nPts*(nPts-1)/2).
	Return: 
		0 for success or -1 for invalid array pointer.
	SeeAlso:
		ocmath_find_array_step_by_probability()
		ocmath_array_step_histogram()
*/
OCMATH_API int ocmath_get_intervals(int nPts, const double* pCoordinates, double* pIntervals);

// Category last updated by Cloud on 05/16/2008
/**$ >Statistics>Descriptive Statistics
	Remarks:
		Calculate the most probable step given a group of intervals between poins.
	Parameters:
		nSize=[input] the length of array pIntervals.
		pIntervals=[input] the intervals calculated from ocmath_get_intervals().
		dStep=[output] the calculated Step.
	Return:
		true of success or false for invalid array pointer.
	SeeAlso:
		ocmath_array_step_histogram()
*/
OCMATH_API bool ocmath_find_array_step_by_probability(int nSize, const double* pIntervals, double* dStep);

//last updated by Mouqx/Leo 09/26/05
// Category last updated by Cloud on 05/16/2008
/**$ >Statistics>Descriptive Statistics
	Remarks:
		Calculate the histogram of the remains of intervals on a given Step. The intervals are mapped to a regular grid with space of dStep,
		and the probability of the relative departure from the grid will be return. A less relative departure indicates the points forms a more 
		regular grid and the dStep is of more accuracy.
	Parameters:
		nSize: the length of array pIntervals.
		pIntervals: the intervals calculated from ocmath_get_intervals().
		dStep=[input] the Step to be evaluated.
		nNumBin=[input] the length of array pReducedX and array pProbability
		pReducedX=[output] the relative departure, vary from -0.5 to 0.5
		pProbability=[output] the probability at each relative departure.
	Example:
		void ocmath_array_step_histogram_ex1()
		{
			double vIn[9] = {1.01,2,3.001,3.998,5,6.002,8,9,10};
			int nPts = 9;	
			int nSize = nPts*(nPts-1)/2;
			double dStep;
			
			double vIntervals[100];
			
			ocmath_get_intervals(nPts, vIn, vIntervals);
			
			bool bfound = ocmath_find_array_step(vIn, nPts, &dStep, 0.01);
			
			if(!bfound)	
				ocmath_find_array_step_by_probability(nSize, vIntervals, &dStep);
			
			int nBinNum = 20;
			
			double vDep[20], vProb[20]; 		
			ocmath_array_step_histogram(nSize, vIntervals, dStep, nBinNum, vDep, vProb);

			printf("step = %f\n", dStep);
			printf("Relative Departure\tProbability\n");
			for(int ii = 0; ii < nBinNum; ii++)
				printf("\t%f\t%f\n", vDep[ii], vProb[ii]);
		}
	Return:
		0 on success or 
		-1 for invalid array pointer or
		-2 for invalid (zero) dStep.
*/
OCMATH_API int ocmath_array_step_histogram(int nSize, const double* pIntervals, double dStep, int nNumBin, double* pReducedX, double* pProbability);

// Category last updated by Justin on 03/26/2007
/**$ >Analysis>Mathematics
	Remarks:
		Calculate the origin of the grid accordingto the coordinates of the points and a calculated dStep.
	Parameters:
		nPts=[input] the number of points in pCoordinates.
		pCoordinates=[input] the coordinates of the points.
		dStep=[input] the step of the grid.
		dGridOrigin=[output] the origin of the grid.
		dGridMax=[output] the maximun of the grid.
	Return:
		0 on success or 
		-1 for invalid array pointer or
		-2 for invalid step.
*/
OCMATH_API int ocmath_array_origin(int nPts, const double* pCoordinates, double dStep, double* dGridOrigin, double* dGridMax);

///END COMPUTE_HISTOGRAM_ON_INTERVAL

///Soapy 3/23/05 MOVE_RENKACLINE_MODSHEPARD_METHOD_FOR_2D_INTERPOLATION
// The following type definition are for 2d interpolation using Renka&Cline method and Modified Shepard's method

// Category last updated by Echo on 01/21/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_modified_shepard_interpolant_(global_function)
*/
///Kevin 11/29/05 CHANGE_OCMATH_FUNCTION_TO_LOWER_CASE
//OCMATH_API int ocmath_Modified_Shepard_interpolant(int npts, double* x,double* y,double* f, 
//		ocmath_ModShepard_Struct *comm, ocmath_ModShepard_Opt *optional);
OCMATH_API int ocmath_modified_shepard_interpolant(int npts, double* x,double* y,double* f, 
		ocmath_ModShepard_Struct *comm, ocmath_ModShepard_Opt *optional);

// Category last updated by Echo on 01/21/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_modified_shepard_eval_(global_function)
*/
///Kevin 11/29/05 CHANGE_OCMATH_FUNCTION_TO_LOWER_CASE
//OCMATH_API int ocmath_Modified_Shepard_eval(ocmath_ModShepard_Struct *comm, int n,
//					double* px,double* py,double* pf);
OCMATH_API int ocmath_modified_shepard_eval(ocmath_ModShepard_Struct *comm, int n,
					double* px,double* py,double* pf);

// Category last updated by Justin on 03/26/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_modshepard_struct_free_(global_function)
*/
///Kevin 11/29/05 CHANGE_OCMATH_FUNCTION_TO_LOWER_CASE
//OCMATH_API int ocmath_ModShepard_Struct_free(ocmath_ModShepard_Struct *comm);
OCMATH_API int ocmath_modshepard_struct_free(ocmath_ModShepard_Struct *comm);


// Category last updated by Echo on 01/21/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_renka_cline_interpolation_(global_function)
*/
///Kevin 11/29/05 CHANGE_OCMATH_FUNCTION_TO_LOWER_CASE
//OCMATH_API int ocmath_Renka_Cline_Interpolation(int npts, double* x, double* y,double* f, 
//		 ocmath_RenkaCline_Struct *comm);
OCMATH_API int ocmath_renka_cline_interpolation(int npts, double* x, double* y,double* f, 
		ocmath_RenkaCline_Struct *comm);

// Comments last updated by Army on 07/31/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_renka_cline_eval_(global_function)
*/
///Kevin 11/29/05 CHANGE_OCMATH_FUNCTION_TO_LOWER_CASE
//OCMATH_API int ocmath_Renka_Cline_eval(ocmath_RenkaCline_Struct *comm,int n,
//					double* px,double* py,double* pf);
OCMATH_API int ocmath_renka_cline_eval(ocmath_RenkaCline_Struct *comm,int n,
									   double* px,double* py,double* pf);

// Comments last updated by Army on 07/31/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_renka_cline_struct_free_(global_function)
*/
///Kevin 11/29/05 CHANGE_OCMATH_FUNCTION_TO_LOWER_CASE
//OCMATH_API int ocmath_RenkaCline_Struct_free(ocmath_RenkaCline_Struct *comm);
OCMATH_API int ocmath_renka_cline_struct_free(ocmath_RenkaCline_Struct *comm);
///END MOVE_RENKACLINE_MODSHEPARD_METHOD_FOR_2D_INTERPOLATION

//Comments last updated by Forest on 03/23/05
// Category last updated by Echo on 01/21/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_2d_kriging_scat_(global_function)
*/
///Eric/Leo  01/10/06   CHANGE_ERROR_CODE_FOR_RETURN
///Kevin 11/29/05 CHANGE_OCMATH_FUNCTION_TO_LOWER_CASE
//OCMATH_API  int kring2D_scat(int npts, double* x, double* y, double* z, int noctMin, double radius, 
//		double dSmooth, int nEvalPTS, double* pX, double* pY, double* pZ);
/// ML 3/22/2006 PROTOTYPE_WITH_CONSTS 
//OCMATH_API  int ocmath_2d_kriging_scat(int npts, double* x, double* y, double* z, int noctMin, double radius, 
//							 double dSmooth, int nEvalPTS, double* pX, double* pY, double* pZ);
/// Fisher Qa80-11497 09/16/09  KRIGGING_CORRELATION_TOO_SLOW_FOR_LARGE_DATA
//OCMATH_API  int ocmath_2d_kriging_scat(int npts, const double* x, const double* y, const double* z, int noctMin, double radius, 
//							 double dSmooth, int nEvalPTS, const double* pX, const double* pY, double* pZ);
OCMATH_API  int ocmath_2d_kriging_scat(int npts, const double* x, const double* y, const double* z, int noctMin, double radius, 
							 double dSmooth, int nEvalPTS, const double* pX, const double* pY, double* pZ, int noctMax = -1);
/// End KRIGGING_CORRELATION_TOO_SLOW_FOR_LARGE_DATA
/// end PROTOTYPE_WITH_CONSTS 

//Comments last updated by Forest on 03/23/05
// Category last updated by Echo on 01/21/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_2d_kriging_grid_(global_function)
*/
///Eric/Leo  01/10/06   CHANGE_ERROR_CODE_FOR_RETURN
///Kevin 11/29/05 CHANGE_OCMATH_FUNCTION_TO_LOWER_CASE
//OCMATH_API int kring2D_grid(int npts, double* x, double* y, double* z, int noctMin, double radius, 
//		double dSmooth, int nXgrid, double* Xgrid, int nYgrid, double* Ygrid, double* Zvalue);
/// Fisher Qa80-11497 09/16/09  KRIGGING_CORRELATION_TOO_SLOW_FOR_LARGE_DATA
//OCMATH_API int ocmath_2d_kriging_grid(int npts, double* x, double* y, double* z, int noctMin, double radius, 
//		double dSmooth, int nXgrid, double* Xgrid, int nYgrid, double* Ygrid, double* Zvalue);
OCMATH_API int ocmath_2d_kriging_grid(int npts, double* x, double* y, double* z, int noctMin, double radius, 
		double dSmooth, int nXgrid, double* Xgrid, int nYgrid, double* Ygrid, double* Zvalue, int noctMax = -1);
/// End KRIGGING_CORRELATION_TOO_SLOW_FOR_LARGE_DATA
///Soapy 07/06/04  QA7.06278  MODIFY_TPS
/*
   Calculate Thin Plate Spline (TPS) weights from
   control points and build a new height grid by
   interpolating with them.							
OCMATH_API int ocmath_tps_getweight(double *x, double *y, double *z, int nSize,
								double regularization, double *weight,double *corra);

OCMATH_API int ocmath_tps_getmatrix(double *x,double *y,
									double *weight,double *corra,int nSize, 
									double *result, int rows, int cols,
									double minx,double maxx,double miny,double maxy);
#ifdef _MSC_VER
	}
#endif	//_MSC_VER
*/

///LEO 03/23/05	ADD_TPS_EXAMPLE_2
// Category last updated by Echo on 01/21/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_tps_fit_(global_function)
*/

///Eric/Leo  01/10/06   CHANGE_ERROR_CODE_FOR_RETURN
/// ML 3/22/2006 PROTOTYPE_WITH_CONSTS 
//OCMATH_API int ocmath_tps_fit(int nNode, double *x, double *y, double *z, 
//					double dSmooth, ocmath_strTPS *strTPS, double* dRegularization);
OCMATH_API int ocmath_tps_fit(int nNode, const double *x, const double *y, const double *z, 
					double dSmooth, ocmath_strTPS *strTPS, double* dRegularization);
/// end PROTOTYPE_WITH_CONSTS 

///End ADD_TPS_EXAMPLE_2

// Category last updated by Echo on 01/21/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_tps_eval_(global_function)
*/
///Eric/Leo  01/10/06   CHANGE_ERROR_CODE_FOR_RETURN
/// ML 3/22/2006 PROTOTYPE_WITH_CONSTS 
//OCMATH_API int ocmath_tps_eval(int np, double *px, double *py, double *pz, ocmath_strTPS *strTPS, bool bExtrapolation = true, double dNAN = NANUM, double dTol = 1E-3);
OCMATH_API int ocmath_tps_eval(int np, const double *px, const double *py, double *pz, ocmath_strTPS *strTPS, bool bExtrapolation = true, double dNAN = NANUM, double dTol = 1E-3);
/// end PROTOTYPE_WITH_CONSTS

// Category last updated by Cloud on 06/05/2008
/**$ >Analysis>Utilities
	Remarks:
		Initialize the tps structure
*/
///Eric/Leo  01/10/06   CHANGE_ERROR_CODE_FOR_RETURN
OCMATH_API int ocmath_tps_initial(ocmath_strTPS *strTPS);
/*
	Free the memory of the structure allocated by ocmath_tps_fit().
*/
///Eric/Leo  01/10/06   CHANGE_ERROR_CODE_FOR_RETURN
OCMATH_API int ocmath_tps_free(ocmath_strTPS *strTPS);
///END Soapy 07/06/04  QA7.06278  MODIFY_TPS

///Mouqx/Leo 2005-12-29 LLVC_GRIDDING_WEIGHTED_AVERAGE
// Category last updated by Echo on 01/21/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_find_xy_in_circle_(global_function)
*/
OCMATH_API int ocmath_find_xy_in_circle(uint nPts, const double* pX, const double* pY,
	uint* pIndices, const double xc, const double yc, const double dRadius);

enum {
	WEIGHTED_AVERAGE_DIRECT,
	WEIGHTED_AVERAGE_SQUARE,
	WEIGHTED_AVERAGE_LOG,
	WEIGHTED_AVERAGE_EXP,
};
// Category last updated by Echo on 01/21/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_gridding_weighted_average_(global_function)
*/
/// ML 3/22/2006 PROTOTYPE_WITH_CONSTS 
//OCMATH_API int ocmath_gridding_weighted_average(int nSize, double* pX, double* pY, double* pZ,
//	int nOutSize, const double* pXout, const double* pYout, double* pZout, double dRadius, int nMethod = WEIGHTED_AVERAGE_SQUARE);
OCMATH_API int ocmath_gridding_weighted_average(int nSize, const double* pX, const double* pY, const double* pZ,
	int nOutSize, const double* pXout, const double* pYout, double* pZout, double dRadius, int nMethod = WEIGHTED_AVERAGE_SQUARE);
/// end PROTOTYPE_WITH_CONSTS 
///end LLVC_GRIDDING_WEIGHTED_AVERAGE

///Mouqx/Leo 2006-1-19 OCMATH_2D_MESH
// Category last updated by Echo on 01/21/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_mesh_in_polygon_(global_function)
*/
OCMATH_API int ocmath_mesh_in_polygon(int nVertices, const double* pxVertices, const double* pyVertices,
	int nEdgePts, int* nMeshPts, double* pxMesh, double* pyMesh);
///end OCMATH_2D_MESH

/// Roy 17/03/2006 OCMATH_D_POLYGON_REORDER
// Category last updated by Cloud on 05/16/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_d_polygon_reorder_(global_function)
*/
OCMATH_API int ocmath_d_polygon_reorder(UINT nSize, double* px, double* py, bool bCCW = true, bool bTest = false);
/// end OCMATH_D_POLYGON_REORDER


/// Fisher 2008-10-7 QA80-12334 IMPROVE_SPEED_FOR_SURFACE_FITTING
OCMATH_API int reduce_3D_data_size( const double* x_data, const double* y_data, const double* z_data, int nSize, double* x_data_re, double*  y_data_re, double* z_data_re, int nx, int ny);
/// End 

/// Will 6/19/2009 QA80-13783 REMOVE_DUPLICATES_FOR_ARRAY
#ifdef __NEW_XYZ_REMOVE_DUPLICATES_METHOD__
OCMATH_API int ocmath_array_remove_duplicates(UINT n, double* x, double dPrecision = 1.0e-8);
#endif // __NEW_XYZ_REMOVE_DUPLICATES_METHOD__
/// End REMOVE_DUPLICATES_FOR_ARRAY

#ifdef _MSC_VER
	}

#endif	//_MSC_VER

///////////////////////////////////////////////////
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// only for oc level, body in Analysis_utils.c 
// please don't add vc level function here
////////////////////////////////////////////////////
#ifndef _MSC_VER
	#pragma dll()
///---Sim 09-25-2009 QA80-13783 PROTOTYPE_WITH_TWO_PRECISION_FOR_XYZ_REMOVE_DUPLICATE
//comments last updated by Sophy on 7/30/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:xyz_remove_duplicates_(global_function)
*/
int xyz_remove_duplicates(UINT n, double* x, double* y, double* z, int nMethod = Remove_With_Mean, double dPrecision = 1.0e-8);
///---END QA80-13783 PROTOTYPE_WITH_TWO_PRECISION_FOR_XYZ_REMOVE_DUPLICATE

///---Sim 09-25-2009 QA80-13783 CHANGE_PROTOTYPE_AND_ALGORITHM_FOR_EXAMINATION
//comments last updated by Sophy on 7/30/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:xyz_examine_data_(global_function)
*/
int xyz_examine_data(UINT nSize, double* x, double* y, double* z, double dPrecision = 1.0e-8, UINT* pVar = NULL,
		double* pXmin = NULL, double* pXStep = NULL, double* pXmax = NULL, double* pYmin = NULL, 
		double* pYStep = NULL, double* pYmax = NULL, bool bRemoveDuplicate = false, int nMethod = Remove_With_Mean);
///---END QA80-13783 CHANGE_PROTOTYPE_AND_ALGORITHM_FOR_EXAMINATION
#endif	//_MSC_VER

#endif //_WKS_TO_MAT_H 
